CREATE PROCEDURE CP_Cbtes_Copiar @Id_Trans INT,@Id_Usuario SMALLINT,@Id_Estado_Cbte SMALLINT
AS

DECLARE @Mensaje			VARCHAR(100)
		,@Id_Trans_Nueva	INT
		,@Descripcion		VARCHAR(100)
		,@Id_Valor			INT
		,@Comprobante_Nro	INT
BEGIN TRY
	BEGIN TRAN

	IF (NOT EXISTS (SELECT 1 FROM Cbtes WHERE Id_Trans = @Id_Trans))
	BEGIN
		SELECT	 1					AS ErrorNumber 
				,0					AS ErrorSeverity  
				,0					AS ErrorState 
				,0					AS ErrorProcedure  
				,0					AS ErrorLine		
				,'No Existe Cbte de Origen'			AS ErrorMessage
				,@Id_Trans      	AS Id_Trans_Original
				,@Id_Trans_Nueva   	AS Id_Trans_Nueva
		ROLLBACK
		RETURN 1
    END

	/*Agre en transacciones*/
	SET @Id_Trans_Nueva = (SELECT MAX(Id_Trans) FROM Transacciones ) + 1
	INSERT INTO Transacciones	(Id_Trans		,Fecha_mov	,Id_Usuario) 
					VALUES		(@Id_Trans_Nueva ,GETDATE()	,@Id_Usuario)

	/*Agrego en Cbtes*/
	SELECT * INTO #Cbtes FROM Cbtes WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes SET Id_Trans = @Id_Trans_Nueva, Id_Estado_Cbte = @Id_Estado_Cbte, Comprobante_Nro = 0
	INSERT INTO Cbtes SELECT * FROM #Cbtes

	/*Agrego en Cbtes_Bcos_Transf*/
	SELECT * INTO #Cbtes_Bcos_Transf FROM Cbtes_Bcos_Transf WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes_Bcos_Transf SET Id_Trans = @Id_Trans_Nueva
	INSERT INTO Cbtes_Bcos_Transf SELECT * FROM #Cbtes_Bcos_Transf

	/*Agrego en Cbtes_Centro_Costos*/
	SELECT * INTO #Cbtes_Centro_Costos FROM Cbtes_Centro_Costos WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes_Centro_Costos SET Id_Trans = @Id_Trans_Nueva
	INSERT INTO Cbtes_Centro_Costos SELECT * FROM #Cbtes_Centro_Costos


	/*Agrego en Cbtes_Conceptos*/
	SELECT * INTO #Cbtes_Conceptos FROM Cbtes_Conceptos WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes_Conceptos SET Id_Trans = @Id_Trans_Nueva
	INSERT INTO Cbtes_Conceptos SELECT * FROM #Cbtes_Conceptos

	/*Agrego en Cbtes_Ctas_Contables*/
	SELECT * INTO #Cbtes_Ctas_Contables FROM Cbtes_Ctas_Contables WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes_Ctas_Contables SET Id_Trans = @Id_Trans_Nueva
	INSERT INTO Cbtes_Ctas_Contables SELECT * FROM #Cbtes_Ctas_Contables

	/*Agrego en Cbtes_Incluidos*/
	SELECT * INTO #Cbtes_Incluidos FROM Cbtes_Incluidos WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes_Incluidos SET Id_Trans = @Id_Trans_Nueva
	INSERT INTO Cbtes_Incluidos SELECT * FROM #Cbtes_Incluidos

	/*Agrego en Cbtes_Items*/
	SELECT * INTO #Cbtes_Items FROM Cbtes_Items WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes_Items SET Id_Trans = @Id_Trans_Nueva
	INSERT INTO Cbtes_Items SELECT * FROM #Cbtes_Items

	/*Agrego en Cbtes_Items_Cajas*/
	/*             No se hace para no generar un caja nueva
	SELECT * INTO #Cbtes_Items_Cajas FROM Cbtes_Items_Cajas WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes_Items_Cajas SET Id_Trans = @Id_Trans_Nueva
	INSERT INTO Cbtes_Items_Cajas SELECT * FROM #Cbtes_Items_Cajas
	*/
	/*Agrego en Cbtes_Items_Comp*/
	SELECT * INTO #Cbtes_Items_Comp FROM Cbtes_Items_Comp WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes_Items_Comp SET Id_Trans = @Id_Trans_Nueva 
	INSERT INTO Cbtes_Items_Comp SELECT * FROM #Cbtes_Items_Comp

	/*Agrego en Cbtes_Items_Planif*/
	SELECT * INTO #Cbtes_Items_Planif FROM Cbtes_Items_Planif WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes_Items_Planif SET Id_Trans = @Id_Trans_Nueva
	INSERT INTO Cbtes_Items_Planif SELECT * FROM #Cbtes_Items_Planif
	
	/*Agrego en Cbtes_Iva*/
	SELECT * INTO #Cbtes_Iva FROM Cbtes_Iva WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes_Iva SET Id_Trans = @Id_Trans_Nueva
	INSERT INTO Cbtes_Iva SELECT * FROM #Cbtes_Iva

	/*Agrego en Cbtes_Reten*/
	SELECT * INTO #Cbtes_Reten FROM Cbtes_Reten WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes_Reten SET Id_Trans = @Id_Trans_Nueva
	INSERT INTO Cbtes_Reten SELECT * FROM #Cbtes_Reten

	/*Agrego en Cbtes_Valores_Canje*/
	SELECT * INTO #Cbtes_Valores_Canje FROM Cbtes_Valores_Canje WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes_Valores_Canje SET Id_Trans = @Id_Trans_Nueva
	INSERT INTO Cbtes_Valores_Canje SELECT * FROM #Cbtes_Valores_Canje

	/*Agrego en Cbtes_Vend*/
	SELECT * INTO #Cbtes_Vend FROM Cbtes_Vend WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes_Vend SET Id_Trans = @Id_Trans_Nueva
	INSERT INTO Cbtes_Vend SELECT * FROM #Cbtes_Vend

	/*Agrego en Cbtes_xCampos*/
	SELECT * INTO #Cbtes_xCampos FROM Cbtes_xCampos WHERE Id_Trans = @Id_Trans
	UPDATE #Cbtes_xCampos SET Id_Trans = @Id_Trans_Nueva
	INSERT INTO Cbtes_xCampos SELECT * FROM #Cbtes_xCampos

	SET @Descripcion =  dbo.CF_Cbte_Descrip(@Id_Trans_Nueva)
	UPDATE Transacciones		SET Descripcion = @Descripcion WHERE Id_Trans = @Id_Trans_Nueva

	/*============================== cuentas corrientes ========================*/
	
	/*Agrego en Clientes_CtaCte*/
	SELECT * INTO #Clientes_CtaCte FROM Clientes_CtaCte WHERE Id_Trans = @Id_Trans
	UPDATE #Clientes_CtaCte SET Id_Trans = @Id_Trans_Nueva, Descripcion = @Descripcion
	INSERT INTO Clientes_CtaCte SELECT * FROM #Clientes_CtaCte

	/*Agrego en Proveedores_CtaCte*/
	SELECT * INTO #Proveedores_CtaCte FROM Proveedores_CtaCte WHERE Id_Trans = @Id_Trans
	UPDATE #Proveedores_CtaCte SET Id_Trans = @Id_Trans_Nueva, Descripcion = @Descripcion
	INSERT INTO Proveedores_CtaCte SELECT * FROM #Proveedores_CtaCte

	/*============================== Caja ========================*/
	/* 
		Cajas se debe copiar con funcin CP_Cajas_Mov_Copiar 
		Valores se debe copiar con funcin CP_Valores_Copiar (tener encuanta no duplicar cheques de terceros)
	*/
	
	IF @Id_Estado_Cbte <> 0 
		EXEC CP_Cbtes_Grabar_Numero @Id_Trans_Nueva

	COMMIT
	SELECT	 0					AS ErrorNumber 
			,0					AS ErrorSeverity  
			,0					AS ErrorState 
			,0					AS ErrorProcedure  
			,0					AS ErrorLine		
			,@Mensaje			AS ErrorMessage
			,@Id_Trans      	AS Id_Trans_Original
			,@Id_Trans_Nueva   	AS Id_Trans_Nueva


END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH;   

